
//#include "io430.h"
#include <msp430.h>

unsigned int indice_ADC = 0;
unsigned int ADC_Result[10];


signed long IDC_results[10];




//------------------------------------------------------------------------------
// SD24_B interrupt service routine
//------------------------------------------------------------------------------
#pragma vector=SD24B_VECTOR
__interrupt void SD24BISR(void)
{
    //P4OUT |= 0x80;                // Toggle P1.0

    
    if (SD24BIFG & SD24IFG0)                                                    // reset by reading one of the SD24BMEML0 or SD24BMEMH0 registers
    {
      IDC_results[0] = SD24BMEMH0;                                              // Save CH0 results (clears IFG), reset SD24IFG0 - SD24BIFG &= ~SD24IFG0;
      IDC_results[0] <<=16;
      IDC_results[0] |= SD24BMEML0;
    }
    if (SD24BIFG & SD24IFG1)
    {
      IDC_results[1] = SD24BMEMH1;                                                // Save CH1 results (clears IFG)
      IDC_results[1] <<=16;
      IDC_results[1] |= SD24BMEML1;
    }
    if (SD24BIFG & SD24IFG2)
    {
      IDC_results[2] = SD24BMEMH2;                                                // Save CH2 results (clears IFG)
      IDC_results[2] <<=16;
      IDC_results[2] |= SD24BMEML2;
    }
    
      SD24BCTL1 &= ~SD24GRP0SC;                                                   // Clear bit for next conversion
    //P4OUT &= ~0x80;                // Toggle P1.0
}

//------------------------------------------------------------------------------
// ADC10 interrupt service routine
//------------------------------------------------------------------------------
#pragma vector=ADC10_VECTOR
__interrupt void ADC10_ISR(void)
{
  //P4OUT |= 0x80;                // Toggle P1.0
  switch (__even_in_range(ADC10IV, 12))
  {
  case  ADC10IV_NONE: break;                // No interrupt
  case  ADC10IV_ADC10OVIFG: break;          // conversion result overflow
  case  ADC10IV_ADC10TOVIFG: break;         // conversion time overflow
  case  ADC10IV_ADC10HIIFG: break;          // ADC10HI
  case  ADC10IV_ADC10LOIFG: break;          // ADC10LO
  case  ADC10IV_ADC10INIFG: break;          // ADC10IN
  case  ADC10IV_ADC10IFG:                   // ADC10
    P4OUT ^= 0x80;                // Toggle P1.0
    ADC_Result[indice_ADC++] = ADC10MEM0;               // Store ADC10 channel 0 result
    if (indice_ADC > 6)
     indice_ADC = 0;
    
    break;
  default: break;
  }
  //P4OUT &= ~0x80;                // Toggle P1.0
}



//------------------------------------------------------------------------------
// Timer0_A0 interrupt service routine
//------------------------------------------------------------------------------
#pragma vector=TIMER0_A0_VECTOR
__interrupt void TIMER0_A0_ISR(void)
{
  //P4OUT |= 0x80;                // Toggle P1.0
  SD24BCTL1 |= SD24GRP0SC;                                                      // Set bit to start conversion

//  ADC10CTL0 |= ADC10SC;                                                         // Sampling and conversion start
}

//------------------------------------------------------------------------------
// Timer0_A1 interrupt service routine
//------------------------------------------------------------------------------
#pragma vector=TIMER0_A1_VECTOR
__interrupt void TIMER0_A1_ISR(void)
{
  
  TA0CTL = 0;
//  switch (__even_in_range(TA0IV, 14))
//  {
//  case  TA0IV_NONE: break;                                                      // No interrupt
//  case  TA0IV_TA0CCR1:                                                          // TA0CCR1_CCIFG
//    //P4OUT ^= 0x80;                // Toggle P1.0
//    break;        
//  case  TA0IV_TA0CCR2:           // TA0CCR2_CCIFG
//    //P4OUT ^= 0x80;                // Toggle P1.0
//    break;
//  case  6: break;                      // Reserved
//  case  8: break;                      // Reserved
//  case 10: break;                      // Reserved
//  case 12: break;                      // Reserved
//  case TA0IV_TA0IFG:                   // TA0IFG
//    //P4OUT &= ~0x80;                // Toggle P1.0
//    break;
//  default: break;
//  }
}

